/* vim: set tabstop=8 shiftwidth=4 softtabstop=4 expandtab smarttab colorcolumn=80: */
/*
 * Copyright 2016 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <jansson.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

#define containerof(ptr, type, member) \
    ((type *)((char *) ptr - offsetof(type, member)))

bool
encode_protected(json_t *obj);

void
zero(void *mem, size_t len);

bool
handle_zip_enc(json_t *jwe, const void *in, size_t len, void **data, size_t *data_len);

bool
zip_in_protected_header(json_t *jwe);
