
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_utilities.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BeginTiming_fcn( HYPRE_Int time_index )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BeginTiming_fcn)( time_index );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BigBinarySearch( HYPRE_BigInt *list, HYPRE_BigInt value, HYPRE_Int list_length )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigBinarySearch)( list, value, list_length );
}

/*--------------------------------------------------------------------------*/

HYPRE_BigInt *
hypre_BigLowerBound( HYPRE_BigInt *first, HYPRE_BigInt *last, HYPRE_BigInt value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigLowerBound)( first, last, value );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigQsort0( HYPRE_BigInt *v, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigQsort0)( v, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigQsort1( HYPRE_BigInt *v, HYPRE_Real *w, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigQsort1)( v, w, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigQsort2i( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigQsort2i)( v, w, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigQsort4_abs( HYPRE_Real *v, HYPRE_BigInt *w, HYPRE_Int *z, HYPRE_Int *y, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigQsort4_abs)( v, w, z, y, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigQsortb2i( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigQsortb2i)( v, w, z, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigQsortbLoc( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigQsortbLoc)( v, w, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigQsortbi( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigQsortbi)( v, w, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigSwap( HYPRE_BigInt *v, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigSwap)( v, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigSwap2( HYPRE_BigInt *v, HYPRE_Real *w, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigSwap2)( v, w, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigSwap2i( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigSwap2i)( v, w, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigSwap4_d( HYPRE_Real *v, HYPRE_BigInt *w, HYPRE_Int *z, HYPRE_Int *y, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigSwap4_d)( v, w, z, y, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigSwapLoc( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigSwapLoc)( v, w, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigSwapb2i( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigSwapb2i)( v, w, z, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_BigSwapbi( HYPRE_BigInt *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BigSwapbi)( v, w, i, j );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BinarySearch( HYPRE_Int *list, HYPRE_Int value, HYPRE_Int list_length )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BinarySearch)( list, value, list_length );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BinarySearch2( HYPRE_Int *list, HYPRE_Int value, HYPRE_Int low, HYPRE_Int high, HYPRE_Int *spot )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BinarySearch2)( list, value, low, high, spot );
}

/*--------------------------------------------------------------------------*/

void *
hypre_CAlloc( size_t count, size_t elt_size, HYPRE_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CAlloc)( count, elt_size, location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CheckDirExists( const char *path )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CheckDirExists)( path );
}

/*--------------------------------------------------------------------------*/

void
hypre_CheckMemoryLocation( void *ptr, hypre_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CheckMemoryLocation)( ptr, location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ClearTiming_fcn( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ClearTiming_fcn)( );
}

/*--------------------------------------------------------------------------*/

char*
hypre_ConvertIndicesToString( HYPRE_Int size, HYPRE_Int *indices )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ConvertIndicesToString)( size, indices );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CreateBinaryTree( HYPRE_Int myid, HYPRE_Int num_procs, hypre_BinaryTree **tree_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CreateBinaryTree)( myid, num_procs, tree_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CreateDir( const char *path )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CreateDir)( path );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CreateNextDirOfSequence( const char *basepath, const char *prefix, char **fullpath_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CreateNextDirOfSequence)( basepath, prefix, fullpath_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_DataExchangeList( HYPRE_Int num_contacts, HYPRE_Int *contact_proc_list, void *contact_send_buf, HYPRE_Int *contact_send_buf_starts, HYPRE_Int contact_obj_size, HYPRE_Int response_obj_size, hypre_DataExchangeResponse *response_obj, HYPRE_Int max_response_size, HYPRE_Int rnum, MPI_Comm comm, void **p_response_recv_buf, HYPRE_Int **p_response_recv_buf_starts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_DataExchangeList)( num_contacts, contact_proc_list, contact_send_buf, contact_send_buf_starts, contact_obj_size, response_obj_size, response_obj, max_response_size, rnum, comm, p_response_recv_buf, p_response_recv_buf_starts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_DestroyBinaryTree( hypre_BinaryTree *tree )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_DestroyBinaryTree)( tree );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_DoubleQuickSplit( HYPRE_Real *values, HYPRE_Int *indices, HYPRE_Int list_length, HYPRE_Int NumberKept )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_DoubleQuickSplit)( values, indices, list_length, NumberKept );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_EndTiming_fcn( HYPRE_Int time_index )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_EndTiming_fcn)( time_index );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FinalizeAllTimings_fcn( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FinalizeAllTimings_fcn)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FinalizeTiming_fcn( HYPRE_Int time_index )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FinalizeTiming_fcn)( time_index );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_Finalized( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_Finalized)( );
}

/*--------------------------------------------------------------------------*/

void
hypre_Free( void *ptr, HYPRE_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_Free)( ptr, location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GetDevice( hypre_int *device_id )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetDevice)( device_id );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GetDeviceCount( hypre_int *device_count )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetDeviceCount)( device_count );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GetDeviceLastError( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetDeviceLastError)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GetDeviceMaxShmemSize( hypre_int device_id, hypre_int *max_size_ptr, hypre_int *max_size_optin_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetDeviceMaxShmemSize)( device_id, max_size_ptr, max_size_optin_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_ExecutionPolicy
hypre_GetExecPolicy1( HYPRE_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetExecPolicy1)( location );
}

/*--------------------------------------------------------------------------*/

HYPRE_ExecutionPolicy
hypre_GetExecPolicy2( HYPRE_MemoryLocation location1, HYPRE_MemoryLocation location2 )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetExecPolicy2)( location1, location2 );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GetGpuAwareMPI( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetGpuAwareMPI)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GetMemoryLocationName( hypre_MemoryLocation memory_location, char *memory_location_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetMemoryLocationName)( memory_location, memory_location_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GetPointerLocation( const void *ptr, hypre_MemoryLocation *memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetPointerLocation)( ptr, memory_location );
}

/*--------------------------------------------------------------------------*/

void
hypre_GetSimpleThreadPartition( HYPRE_Int *begin, HYPRE_Int *end, HYPRE_Int n )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetSimpleThreadPartition)( begin, end, n );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GetTiming_fcn( const char *heading, HYPRE_Real *wall_time_ptr, MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetTiming_fcn)( heading, wall_time_ptr, comm );
}

/*--------------------------------------------------------------------------*/

void
hypre_GpuProfilingPopRange( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GpuProfilingPopRange)( );
}

/*--------------------------------------------------------------------------*/

void
hypre_GpuProfilingPushRange( const char *name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GpuProfilingPushRange)( name );
}

/*--------------------------------------------------------------------------*/

void
hypre_GpuProfilingPushRangeColor( const char *name, HYPRE_Int cid )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GpuProfilingPushRangeColor)( name, cid );
}

/*--------------------------------------------------------------------------*/

hypre_Handle*
hypre_HandleCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HandleCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HandleDestroy( hypre_Handle *hypre_handle_ )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HandleDestroy)( hypre_handle_ );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HostMemoryGetUsage( HYPRE_Real *mem )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HostMemoryGetUsage)( mem );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IncFLOPCount_fcn( HYPRE_BigInt inc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IncFLOPCount_fcn)( inc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_InitializeTiming_fcn( const char *name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_InitializeTiming_fcn)( name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_Initialized( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_Initialized)( );
}

/*--------------------------------------------------------------------------*/

hypre_IntArrayArray*
hypre_IntArrayArrayCreate( HYPRE_Int num_entries, HYPRE_Int *sizes )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayArrayCreate)( num_entries, sizes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayArrayDestroy( hypre_IntArrayArray *w )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayArrayDestroy)( w );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayArrayInitialize( hypre_IntArrayArray *w )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayArrayInitialize)( w );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayArrayInitializeIn( hypre_IntArrayArray *w, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayArrayInitializeIn)( w, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayArrayMigrate( hypre_IntArrayArray *w, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayArrayMigrate)( w, memory_location );
}

/*--------------------------------------------------------------------------*/

hypre_IntArray*
hypre_IntArrayCloneDeep( hypre_IntArray *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayCloneDeep)( x );
}

/*--------------------------------------------------------------------------*/

hypre_IntArray*
hypre_IntArrayCloneDeep_v2( hypre_IntArray *x, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayCloneDeep_v2)( x, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayCopy( hypre_IntArray *x, hypre_IntArray *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayCopy)( x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayCount( hypre_IntArray *v, HYPRE_Int value, HYPRE_Int *num_values_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayCount)( v, value, num_values_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayCountHost( hypre_IntArray *v, HYPRE_Int value, HYPRE_Int *num_values_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayCountHost)( v, value, num_values_ptr );
}

/*--------------------------------------------------------------------------*/

hypre_IntArray*
hypre_IntArrayCreate( HYPRE_Int size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayCreate)( size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayDestroy( hypre_IntArray *array )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayDestroy)( array );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayInitialize( hypre_IntArray *array )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayInitialize)( array );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayInitialize_v2( hypre_IntArray *array, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayInitialize_v2)( array, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayInverseMapping( hypre_IntArray *v, hypre_IntArray **w_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayInverseMapping)( v, w_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayMergeOrdered( hypre_IntArray *array1, hypre_IntArray *array2, hypre_IntArray *array3 )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayMergeOrdered)( array1, array2, array3 );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayMigrate( hypre_IntArray *v, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayMigrate)( v, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayNegate( hypre_IntArray *v )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayNegate)( v );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayPrint( MPI_Comm comm, hypre_IntArray *array, const char *filename )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayPrint)( comm, array, filename );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArrayRead( MPI_Comm comm, const char *filename, hypre_IntArray **array_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArrayRead)( comm, filename, array_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArraySeparateByValue( HYPRE_Int num_values, HYPRE_Int *values, HYPRE_Int *sizes, hypre_IntArray *v, hypre_IntArrayArray **w_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArraySeparateByValue)( num_values, values, sizes, v, w_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArraySetConstantValues( hypre_IntArray *v, HYPRE_Int value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArraySetConstantValues)( v, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArraySetConstantValuesHost( hypre_IntArray *v, HYPRE_Int value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArraySetConstantValuesHost)( v, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntArraySetInterleavedValues( hypre_IntArray *v, HYPRE_Int cycle )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntArraySetInterleavedValues)( v, cycle );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntSequence( HYPRE_MemoryLocation memory_location, HYPRE_Int size, HYPRE_Int *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntSequence)( memory_location, size, data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_Log2( HYPRE_Int p )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_Log2)( p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int *
hypre_LowerBound( HYPRE_Int *first, HYPRE_Int *last, HYPRE_Int value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LowerBound)( first, last, value );
}

/*--------------------------------------------------------------------------*/

void *
hypre_MAlloc( size_t size, HYPRE_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MAlloc)( size, location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Abort( hypre_MPI_Comm comm, HYPRE_Int errorcode )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Abort)( comm, errorcode );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Address( void *location, hypre_MPI_Aint *address )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Address)( location, address );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Allgather( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Allgather)( sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Allgatherv( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int *recvcounts, HYPRE_Int *displs, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Allgatherv)( sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Allreduce( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Allreduce)( sendbuf, recvbuf, count, datatype, op, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Alltoall( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Alltoall)( sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Barrier( hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Barrier)( comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Bcast( void *buffer, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int root, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Bcast)( buffer, count, datatype, root, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_CheckCommMatrix( hypre_MPI_Comm comm, HYPRE_Int num_recvs, HYPRE_Int *recvs, HYPRE_Int num_sends, HYPRE_Int *sends )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_CheckCommMatrix)( comm, num_recvs, recvs, num_sends, sends );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Comm_create( hypre_MPI_Comm comm, hypre_MPI_Group group, hypre_MPI_Comm *newcomm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Comm_create)( comm, group, newcomm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Comm_dup( hypre_MPI_Comm comm, hypre_MPI_Comm *newcomm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Comm_dup)( comm, newcomm );
}

/*--------------------------------------------------------------------------*/

hypre_MPI_Comm
hypre_MPI_Comm_f2c( hypre_int comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Comm_f2c)( comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Comm_free( hypre_MPI_Comm *comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Comm_free)( comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Comm_group( hypre_MPI_Comm comm, hypre_MPI_Group *group )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Comm_group)( comm, group );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Comm_rank( hypre_MPI_Comm comm, HYPRE_Int *rank )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Comm_rank)( comm, rank );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Comm_size( hypre_MPI_Comm comm, HYPRE_Int *size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Comm_size)( comm, size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Comm_split( hypre_MPI_Comm comm, HYPRE_Int n, HYPRE_Int m, hypre_MPI_Comm * comms )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Comm_split)( comm, n, m, comms );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Finalize( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Finalize)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Gather( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Gather)( sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Gatherv( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int *recvcounts, HYPRE_Int *displs, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Gatherv)( sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, root, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Get_count( hypre_MPI_Status *status, hypre_MPI_Datatype datatype, HYPRE_Int *count )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Get_count)( status, datatype, count );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Group_free( hypre_MPI_Group *group )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Group_free)( group );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Group_incl( hypre_MPI_Group group, HYPRE_Int n, HYPRE_Int *ranks, hypre_MPI_Group *newgroup )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Group_incl)( group, n, ranks, newgroup );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Init( hypre_int *argc, char ***argv )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Init)( argc, argv );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Iprobe( HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, HYPRE_Int *flag, hypre_MPI_Status *status )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Iprobe)( source, tag, comm, flag, status );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Irecv( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Irecv)( buf, count, datatype, source, tag, comm, request );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Irsend( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Irsend)( buf, count, datatype, dest, tag, comm, request );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Isend( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Isend)( buf, count, datatype, dest, tag, comm, request );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Op_create( hypre_MPI_User_function *function, hypre_int commute, hypre_MPI_Op *op )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Op_create)( function, commute, op );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Op_free( hypre_MPI_Op *op )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Op_free)( op );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Probe( HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Status *status )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Probe)( source, tag, comm, status );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Recv( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int source, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Status *status )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Recv)( buf, count, datatype, source, tag, comm, status );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Recv_init( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Recv_init)( buf, count, datatype, dest, tag, comm, request );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Reduce( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, HYPRE_Int root, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Reduce)( sendbuf, recvbuf, count, datatype, op, root, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Request_free( hypre_MPI_Request *request )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Request_free)( request );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Scan( void *sendbuf, void *recvbuf, HYPRE_Int count, hypre_MPI_Datatype datatype, hypre_MPI_Op op, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Scan)( sendbuf, recvbuf, count, datatype, op, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Scatter( void *sendbuf, HYPRE_Int sendcount, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Scatter)( sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Scatterv( void *sendbuf, HYPRE_Int *sendcounts, HYPRE_Int *displs, hypre_MPI_Datatype sendtype, void *recvbuf, HYPRE_Int recvcount, hypre_MPI_Datatype recvtype, HYPRE_Int root, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Scatterv)( sendbuf, sendcounts, displs, sendtype, recvbuf, recvcount, recvtype, root, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Send( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Send)( buf, count, datatype, dest, tag, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Send_init( void *buf, HYPRE_Int count, hypre_MPI_Datatype datatype, HYPRE_Int dest, HYPRE_Int tag, hypre_MPI_Comm comm, hypre_MPI_Request *request )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Send_init)( buf, count, datatype, dest, tag, comm, request );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Startall( HYPRE_Int count, hypre_MPI_Request *array_of_requests )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Startall)( count, array_of_requests );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Test( hypre_MPI_Request *request, HYPRE_Int *flag, hypre_MPI_Status *status )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Test)( request, flag, status );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Testall( HYPRE_Int count, hypre_MPI_Request *array_of_requests, HYPRE_Int *flag, hypre_MPI_Status *array_of_statuses )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Testall)( count, array_of_requests, flag, array_of_statuses );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Type_commit( hypre_MPI_Datatype *datatype )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Type_commit)( datatype );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Type_contiguous( HYPRE_Int count, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Type_contiguous)( count, oldtype, newtype );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Type_free( hypre_MPI_Datatype *datatype )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Type_free)( datatype );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Type_hvector( HYPRE_Int count, HYPRE_Int blocklength, hypre_MPI_Aint stride, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Type_hvector)( count, blocklength, stride, oldtype, newtype );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Type_struct( HYPRE_Int count, HYPRE_Int *array_of_blocklengths, hypre_MPI_Aint *array_of_displacements, hypre_MPI_Datatype *array_of_types, hypre_MPI_Datatype *newtype )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Type_struct)( count, array_of_blocklengths, array_of_displacements, array_of_types, newtype );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Type_vector( HYPRE_Int count, HYPRE_Int blocklength, HYPRE_Int stride, hypre_MPI_Datatype oldtype, hypre_MPI_Datatype *newtype )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Type_vector)( count, blocklength, stride, oldtype, newtype );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Wait( hypre_MPI_Request *request, hypre_MPI_Status *status )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Wait)( request, status );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Waitall( HYPRE_Int count, hypre_MPI_Request *array_of_requests, hypre_MPI_Status *array_of_statuses )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Waitall)( count, array_of_requests, array_of_statuses );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPI_Waitany( HYPRE_Int count, hypre_MPI_Request *array_of_requests, HYPRE_Int *index, hypre_MPI_Status *status )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Waitany)( count, array_of_requests, index, status );
}

/*--------------------------------------------------------------------------*/

hypre_double
hypre_MPI_Wtick( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Wtick)( );
}

/*--------------------------------------------------------------------------*/

hypre_double
hypre_MPI_Wtime( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPI_Wtime)( );
}

/*--------------------------------------------------------------------------*/

hypre_MatrixStatsArray*
hypre_MatrixStatsArrayCreate( HYPRE_Int capacity )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MatrixStatsArrayCreate)( capacity );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MatrixStatsArrayDestroy( hypre_MatrixStatsArray *stats_array )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MatrixStatsArrayDestroy)( stats_array );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MatrixStatsArrayPrint( HYPRE_Int num_hierarchies, HYPRE_Int *num_levels, HYPRE_Int use_divisors, HYPRE_Int shift, const char **messages, hypre_MatrixStatsArray *stats_array )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MatrixStatsArrayPrint)( num_hierarchies, num_levels, use_divisors, shift, messages, stats_array );
}

/*--------------------------------------------------------------------------*/

hypre_MatrixStats*
hypre_MatrixStatsCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MatrixStatsCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MatrixStatsDestroy( hypre_MatrixStats *stats )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MatrixStatsDestroy)( stats );
}

/*--------------------------------------------------------------------------*/

void
hypre_MemPrefetch( void *ptr, size_t size, HYPRE_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MemPrefetch)( ptr, size, location );
}

/*--------------------------------------------------------------------------*/

void
hypre_Memcpy( void *dst, void *src, size_t size, HYPRE_MemoryLocation loc_dst, HYPRE_MemoryLocation loc_src )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_Memcpy)( dst, src, size, loc_dst, loc_src );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MemoryPrintUsage( MPI_Comm comm, HYPRE_Int level, const char *function, HYPRE_Int line )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MemoryPrintUsage)( comm, level, function, line );
}

/*--------------------------------------------------------------------------*/

void *
hypre_Memset( void *ptr, HYPRE_Int value, size_t num, HYPRE_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_Memset)( ptr, value, num, location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PrefixSumInt( HYPRE_Int nvals, HYPRE_Int *vals, HYPRE_Int *sums )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PrefixSumInt)( nvals, vals, sums );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PrintTiming_fcn( const char *heading, MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PrintTiming_fcn)( heading, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_Rand( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_Rand)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RandI( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RandI)( );
}

/*--------------------------------------------------------------------------*/

void *
hypre_ReAlloc( void *ptr, size_t size, HYPRE_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ReAlloc)( ptr, size, location );
}

/*--------------------------------------------------------------------------*/

void *
hypre_ReAlloc_v2( void *ptr, size_t old_size, size_t new_size, HYPRE_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ReAlloc_v2)( ptr, old_size, new_size, location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RestoreLogLevel( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RestoreLogLevel)( );
}

/*--------------------------------------------------------------------------*/

void
hypre_SeedRand( HYPRE_Int seed )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeedRand)( seed );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetCubMemPoolSize( hypre_uint bin_growth, hypre_uint min_bin, hypre_uint max_bin, size_t max_cached_bytes )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetCubMemPoolSize)( bin_growth, min_bin, max_bin, max_cached_bytes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetDevice( hypre_int device_id, hypre_Handle *hypre_handle_ )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetDevice)( device_id, hypre_handle_ );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetFinalized( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetFinalized)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetGaussSeidelMethod( HYPRE_Int gs_method )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetGaussSeidelMethod)( gs_method );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetGpuAwareMPI( HYPRE_Int use_gpu_aware_mpi )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetGpuAwareMPI)( use_gpu_aware_mpi );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetInitialized( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetInitialized)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetLogLevel( HYPRE_Int log_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetLogLevel)( log_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetLogLevelSaved( HYPRE_Int log_level_saved )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetLogLevelSaved)( log_level_saved );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetSpGemmAlgorithm( HYPRE_Int value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetSpGemmAlgorithm)( value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetSpGemmBinned( HYPRE_Int value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetSpGemmBinned)( value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetSpGemmRownnzEstimateMethod( HYPRE_Int value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetSpGemmRownnzEstimateMethod)( value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetSpGemmRownnzEstimateMultFactor( HYPRE_Real value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetSpGemmRownnzEstimateMultFactor)( value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetSpGemmRownnzEstimateNSamples( HYPRE_Int value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetSpGemmRownnzEstimateNSamples)( value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetSpGemmUseVendor( HYPRE_Int use_vendor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetSpGemmUseVendor)( use_vendor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetSpMVUseVendor( HYPRE_Int use_vendor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetSpMVUseVendor)( use_vendor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetSpTransUseVendor( HYPRE_Int use_vendor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetSpTransUseVendor)( use_vendor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetUseGpuRand( HYPRE_Int use_gpurand )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetUseGpuRand)( use_gpurand );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetUserDeviceMalloc( GPUMallocFunc func )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetUserDeviceMalloc)( func );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SetUserDeviceMfree( GPUMfreeFunc func )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SetUserDeviceMfree)( func );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_UniqueIntArrayND( HYPRE_Int ndim, HYPRE_Int *size, HYPRE_Int **array )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_UniqueIntArrayND)( ndim, size, array );
}

/*--------------------------------------------------------------------------*/

void
hypre_UnorderedBigIntMapCreate( hypre_UnorderedBigIntMap *m, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_UnorderedBigIntMapCreate)( m, inCapacity, concurrencyLevel );
}

/*--------------------------------------------------------------------------*/

void
hypre_UnorderedBigIntMapDestroy( hypre_UnorderedBigIntMap *m )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_UnorderedBigIntMapDestroy)( m );
}

/*--------------------------------------------------------------------------*/

HYPRE_BigInt *
hypre_UnorderedBigIntSetCopyToArray( hypre_UnorderedBigIntSet *s, HYPRE_Int *len )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_UnorderedBigIntSetCopyToArray)( s, len );
}

/*--------------------------------------------------------------------------*/

void
hypre_UnorderedBigIntSetCreate( hypre_UnorderedBigIntSet *s, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_UnorderedBigIntSetCreate)( s, inCapacity, concurrencyLevel );
}

/*--------------------------------------------------------------------------*/

void
hypre_UnorderedBigIntSetDestroy( hypre_UnorderedBigIntSet *s )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_UnorderedBigIntSetDestroy)( s );
}

/*--------------------------------------------------------------------------*/

void
hypre_UnorderedIntMapCreate( hypre_UnorderedIntMap *m, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_UnorderedIntMapCreate)( m, inCapacity, concurrencyLevel );
}

/*--------------------------------------------------------------------------*/

void
hypre_UnorderedIntMapDestroy( hypre_UnorderedIntMap *m )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_UnorderedIntMapDestroy)( m );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int *
hypre_UnorderedIntSetCopyToArray( hypre_UnorderedIntSet *s, HYPRE_Int *len )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_UnorderedIntSetCopyToArray)( s, len );
}

/*--------------------------------------------------------------------------*/

void
hypre_UnorderedIntSetCreate( hypre_UnorderedIntSet *s, HYPRE_Int inCapacity, HYPRE_Int concurrencyLevel )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_UnorderedIntSetCreate)( s, inCapacity, concurrencyLevel );
}

/*--------------------------------------------------------------------------*/

void
hypre_UnorderedIntSetDestroy( hypre_UnorderedIntSet *s )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_UnorderedIntSetDestroy)( s );
}

/*--------------------------------------------------------------------------*/

void
hypre__Free( void *ptr, hypre_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre__Free)( ptr, location );
}

/*--------------------------------------------------------------------------*/

void *
hypre__MAlloc( size_t size, hypre_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre__MAlloc)( size, location );
}

/*--------------------------------------------------------------------------*/

void
hypre_big_merge_sort( HYPRE_BigInt *in, HYPRE_BigInt *temp, HYPRE_Int len, HYPRE_BigInt **sorted )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_big_merge_sort)( in, temp, len, sorted );
}

/*--------------------------------------------------------------------------*/

void
hypre_big_sort_and_create_inverse_map( HYPRE_BigInt *in, HYPRE_Int len, HYPRE_BigInt **out, hypre_UnorderedBigIntMap *inverse_map )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_big_sort_and_create_inverse_map)( in, len, out, inverse_map );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_bind_device( HYPRE_Int myid, HYPRE_Int nproc, MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_bind_device)( myid, nproc, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_bind_device_id( HYPRE_Int device_id_in, HYPRE_Int myid, HYPRE_Int nproc, MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_bind_device_id)( device_id_in, myid, nproc, comm );
}

/*--------------------------------------------------------------------------*/

hypre_LinkList
hypre_create_elt( HYPRE_Int Item )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_create_elt)( Item );
}

/*--------------------------------------------------------------------------*/

void
hypre_dense_topo_sort( const HYPRE_Complex *L, HYPRE_Int *ordering, HYPRE_Int n, HYPRE_Int is_col_major )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dense_topo_sort)( L, ordering, n, is_col_major );
}

/*--------------------------------------------------------------------------*/

void
hypre_dispose_elt( hypre_LinkList element_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dispose_elt)( element_ptr );
}

/*--------------------------------------------------------------------------*/

void
hypre_enter_on_lists( hypre_LinkList *LoL_head_ptr, hypre_LinkList *LoL_tail_ptr, HYPRE_Int measure, HYPRE_Int index, HYPRE_Int *lists, HYPRE_Int *where )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_enter_on_lists)( LoL_head_ptr, LoL_tail_ptr, measure, index, lists, where );
}

/*--------------------------------------------------------------------------*/

void
hypre_error_code_restore( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_error_code_restore)( );
}

/*--------------------------------------------------------------------------*/

void
hypre_error_code_save( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_error_code_save)( );
}

/*--------------------------------------------------------------------------*/

void
hypre_error_handler( const char *filename, HYPRE_Int line, HYPRE_Int ierr, const char *msg )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_error_handler)( filename, line, ierr, msg );
}

/*--------------------------------------------------------------------------*/

void
hypre_error_handler_clear_messages( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_error_handler_clear_messages)( );
}

/*--------------------------------------------------------------------------*/

hypre_Handle*
hypre_handle( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_handle)( );
}

/*--------------------------------------------------------------------------*/

void
hypre_merge_sort( HYPRE_Int *in, HYPRE_Int *temp, HYPRE_Int len, HYPRE_Int **sorted )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_merge_sort)( in, temp, len, sorted );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_mm_is_valid( MM_typecode matcode )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_mm_is_valid)( matcode );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_mm_read_banner( FILE *f, MM_typecode *matcode )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_mm_read_banner)( f, matcode );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_mm_read_mtx_crd_size( FILE *f, HYPRE_Int *M, HYPRE_Int *N, HYPRE_Int *nz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_mm_read_mtx_crd_size)( f, M, N, nz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_multmod( HYPRE_Int a, HYPRE_Int b, HYPRE_Int mod )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_multmod)( a, b, mod );
}

/*--------------------------------------------------------------------------*/

void
hypre_partition1D( HYPRE_Int n, HYPRE_Int p, HYPRE_Int j, HYPRE_Int *s, HYPRE_Int *e )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_partition1D)( n, p, j, s, e );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_prefix_sum( HYPRE_Int *in_out, HYPRE_Int *sum, HYPRE_Int *workspace )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_prefix_sum)( in_out, sum, workspace );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_prefix_sum_multiple( HYPRE_Int *in_out, HYPRE_Int *sum, HYPRE_Int n, HYPRE_Int *workspace )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_prefix_sum_multiple)( in_out, sum, n, workspace );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_prefix_sum_pair( HYPRE_Int *in_out1, HYPRE_Int *sum1, HYPRE_Int *in_out2, HYPRE_Int *sum2, HYPRE_Int *workspace )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_prefix_sum_pair)( in_out1, sum1, in_out2, sum2, workspace );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_prefix_sum_triple( HYPRE_Int *in_out1, HYPRE_Int *sum1, HYPRE_Int *in_out2, HYPRE_Int *sum2, HYPRE_Int *in_out3, HYPRE_Int *sum3, HYPRE_Int *workspace )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_prefix_sum_triple)( in_out1, sum1, in_out2, sum2, in_out3, sum3, workspace );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsort0( HYPRE_Int *v, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsort0)( v, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsort1( HYPRE_Int *v, HYPRE_Real *w, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsort1)( v, w, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsort2( HYPRE_Int *v, HYPRE_Real *w, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsort2)( v, w, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsort2_abs( HYPRE_Int *v, HYPRE_Real *w, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsort2_abs)( v, w, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsort2i( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsort2i)( v, w, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsort3( HYPRE_Real *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsort3)( v, w, z, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsort3_abs( HYPRE_Real *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsort3_abs)( v, w, z, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsort3i( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsort3i)( v, w, z, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsort3ir( HYPRE_Int *v, HYPRE_Real *w, HYPRE_Int *z, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsort3ir)( v, w, z, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsortND( HYPRE_Int **v, HYPRE_Int ndim, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsortND)( v, ndim, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsort_abs( HYPRE_Real *w, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsort_abs)( w, left, right );
}

/*--------------------------------------------------------------------------*/

void
hypre_remove_point( hypre_LinkList *LoL_head_ptr, hypre_LinkList *LoL_tail_ptr, HYPRE_Int measure, HYPRE_Int index, HYPRE_Int *lists, HYPRE_Int *where )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_remove_point)( LoL_head_ptr, LoL_tail_ptr, measure, index, lists, where );
}

/*--------------------------------------------------------------------------*/

char *
hypre_strcpy( char *destination, const char *source )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_strcpy)( destination, source );
}

/*--------------------------------------------------------------------------*/

void
hypre_swap( HYPRE_Int *v, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_swap)( v, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_swap2( HYPRE_Int *v, HYPRE_Real *w, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_swap2)( v, w, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_swap2i( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_swap2i)( v, w, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_swap3_d( HYPRE_Real *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_swap3_d)( v, w, z, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_swap3_d_perm( HYPRE_Int *v, HYPRE_Real *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_swap3_d_perm)( v, w, z, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_swap3i( HYPRE_Int *v, HYPRE_Int *w, HYPRE_Int *z, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_swap3i)( v, w, z, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_swap_c( HYPRE_Complex *v, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_swap_c)( v, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_swap_d( HYPRE_Real *v, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_swap_d)( v, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_topo_sort( const HYPRE_Int *row_ptr, const HYPRE_Int *col_inds, const HYPRE_Complex *data, HYPRE_Int *ordering, HYPRE_Int n )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_topo_sort)( row_ptr, col_inds, data, ordering, n );
}

/*--------------------------------------------------------------------------*/

void
hypre_union2( HYPRE_Int n1, HYPRE_BigInt *arr1, HYPRE_Int n2, HYPRE_BigInt *arr2, HYPRE_Int *n3, HYPRE_BigInt *arr3, HYPRE_Int *map1, HYPRE_Int *map2 )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_union2)( n1, arr1, n2, arr2, n3, arr3, map1, map2 );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
time_getCPUSeconds( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(time_getCPUSeconds)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
time_getWallclockSeconds( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(time_getWallclockSeconds)( );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixAdd( HYPRE_Real a, utilities_FortranMatrix* mtxA, utilities_FortranMatrix* mtxB, utilities_FortranMatrix* mtxC )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixAdd)( a, mtxA, mtxB, mtxC );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixAllocateData( HYPRE_BigInt h, HYPRE_BigInt w, utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixAllocateData)( h, w, mtx );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixClear( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixClear)( mtx );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixClearL( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixClearL)( mtx );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixCopy( utilities_FortranMatrix* src, HYPRE_Int t, utilities_FortranMatrix* dest )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixCopy)( src, t, dest );
}

/*--------------------------------------------------------------------------*/

utilities_FortranMatrix*
utilities_FortranMatrixCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixCreate)( );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixDMultiply( utilities_FortranMatrix* d, utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixDMultiply)( d, mtx );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixDestroy( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixDestroy)( mtx );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
utilities_FortranMatrixFNorm( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixFNorm)( mtx );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixGetDiagonal( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixGetDiagonal)( mtx, d );
}

/*--------------------------------------------------------------------------*/

HYPRE_BigInt
utilities_FortranMatrixGlobalHeight( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixGlobalHeight)( mtx );
}

/*--------------------------------------------------------------------------*/

HYPRE_BigInt
utilities_FortranMatrixHeight( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixHeight)( mtx );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixIndexCopy( HYPRE_Int* index, utilities_FortranMatrix* src, HYPRE_Int t, utilities_FortranMatrix* dest )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixIndexCopy)( index, src, t, dest );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
utilities_FortranMatrixMaxValue( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixMaxValue)( mtx );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixMultiply( utilities_FortranMatrix* mtxA, HYPRE_Int tA, utilities_FortranMatrix* mtxB, HYPRE_Int tB, utilities_FortranMatrix* mtxC )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixMultiply)( mtxA, tA, mtxB, tB, mtxC );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixMultiplyD( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixMultiplyD)( mtx, d );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
utilities_FortranMatrixPrint( utilities_FortranMatrix* mtx, const char *fileName )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixPrint)( mtx, fileName );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixSelectBlock( utilities_FortranMatrix* mtx, HYPRE_BigInt iFrom, HYPRE_BigInt iTo, HYPRE_BigInt jFrom, HYPRE_BigInt jTo, utilities_FortranMatrix* block )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixSelectBlock)( mtx, iFrom, iTo, jFrom, jTo, block );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixSetDiagonal( utilities_FortranMatrix* mtx, utilities_FortranMatrix* d )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixSetDiagonal)( mtx, d );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixSetToIdentity( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixSetToIdentity)( mtx );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixSymmetrize( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixSymmetrize)( mtx );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixTransposeSquare( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixTransposeSquare)( mtx );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixUpperInv( utilities_FortranMatrix* u )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixUpperInv)( u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
utilities_FortranMatrixValue( utilities_FortranMatrix* mtx, HYPRE_BigInt i, HYPRE_BigInt j )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixValue)( mtx, i, j );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real*
utilities_FortranMatrixValuePtr( utilities_FortranMatrix* mtx, HYPRE_BigInt i, HYPRE_BigInt j )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixValuePtr)( mtx, i, j );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real*
utilities_FortranMatrixValues( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixValues)( mtx );
}

/*--------------------------------------------------------------------------*/

HYPRE_BigInt
utilities_FortranMatrixWidth( utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixWidth)( mtx );
}

/*--------------------------------------------------------------------------*/

void
utilities_FortranMatrixWrap( HYPRE_Real* v, HYPRE_BigInt gh, HYPRE_BigInt h, HYPRE_BigInt w, utilities_FortranMatrix* mtx )
{
   return HYPRE_CURRENTPRECISION_FUNC(utilities_FortranMatrixWrap)( v, gh, h, w, mtx );
}


#endif

