
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_krylov.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*--------------------------------------------------------------------------*/

void *
hypre_BiCGSTABCreate( hypre_BiCGSTABFunctions *bicgstab_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABCreate)( bicgstab_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABDestroy( void *bicgstab_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABDestroy)( bicgstab_vdata );
}

/*--------------------------------------------------------------------------*/

hypre_BiCGSTABFunctions *
hypre_BiCGSTABFunctionsCreate( hypre_KrylovPtrToCreateVector CreateVector, hypre_KrylovPtrToDestroyVector DestroyVector, hypre_KrylovPtrToMatvecCreate MatvecCreate, hypre_KrylovPtrToMatvec Matvec, hypre_KrylovPtrToMatvecDestroy MatvecDestroy, hypre_KrylovPtrToInnerProd InnerProd, hypre_KrylovPtrToCopyVector CopyVector, hypre_KrylovPtrToClearVector ClearVector, hypre_KrylovPtrToScaleVector ScaleVector, hypre_KrylovPtrToAxpy Axpy, hypre_KrylovPtrToCommInfo CommInfo, hypre_KrylovPtrToPrecond Precond, hypre_KrylovPtrToPrecondSetup PrecondSetup )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABFunctionsCreate)( CreateVector, DestroyVector, MatvecCreate, Matvec, MatvecDestroy, InnerProd, CopyVector, ClearVector, ScaleVector, Axpy, CommInfo, Precond, PrecondSetup );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABGetConverged( void *bicgstab_vdata, HYPRE_Int *converged )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABGetConverged)( bicgstab_vdata, converged );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABGetFinalRelativeResidualNorm( void *bicgstab_vdata, HYPRE_Real *relative_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABGetFinalRelativeResidualNorm)( bicgstab_vdata, relative_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABGetNumIterations( void *bicgstab_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABGetNumIterations)( bicgstab_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABGetPrecond( void *bicgstab_vdata, HYPRE_Solver *precond_data_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABGetPrecond)( bicgstab_vdata, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABGetPrecondMatrix( void *bicgstab_vdata, HYPRE_Matrix *precond_matrix_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABGetPrecondMatrix)( bicgstab_vdata, precond_matrix_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABGetResidual( void *bicgstab_vdata, void **residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABGetResidual)( bicgstab_vdata, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetAbsoluteTol( void *bicgstab_vdata, HYPRE_Real a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetAbsoluteTol)( bicgstab_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetConvergenceFactorTol( void *bicgstab_vdata, HYPRE_Real cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetConvergenceFactorTol)( bicgstab_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetHybrid( void *bicgstab_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetHybrid)( bicgstab_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetLogging( void *bicgstab_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetLogging)( bicgstab_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetMaxIter( void *bicgstab_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetMaxIter)( bicgstab_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetMinIter( void *bicgstab_vdata, HYPRE_Int min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetMinIter)( bicgstab_vdata, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetPrecond( void *bicgstab_vdata, hypre_KrylovPtrToPrecond precond, hypre_KrylovPtrToPrecondSetup precond_setup, void *precond_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetPrecond)( bicgstab_vdata, precond, precond_setup, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetPrecondMatrix( void *bicgstab_vdata, void *precond_matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetPrecondMatrix)( bicgstab_vdata, precond_matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetPrintLevel( void *bicgstab_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetPrintLevel)( bicgstab_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetStopCrit( void *bicgstab_vdata, HYPRE_Int stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetStopCrit)( bicgstab_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetTol( void *bicgstab_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetTol)( bicgstab_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSetup( void *bicgstab_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSetup)( bicgstab_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BiCGSTABSolve( void *bicgstab_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BiCGSTABSolve)( bicgstab_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_CGNRCreate( hypre_CGNRFunctions *cgnr_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRCreate)( cgnr_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRDestroy( void *cgnr_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRDestroy)( cgnr_vdata );
}

/*--------------------------------------------------------------------------*/

hypre_CGNRFunctions *
hypre_CGNRFunctionsCreate( hypre_KrylovPtrToCommInfo CommInfo, hypre_KrylovPtrToCreateVector CreateVector, hypre_KrylovPtrToDestroyVector DestroyVector, hypre_KrylovPtrToMatvecCreate MatvecCreate, hypre_KrylovPtrToMatvec Matvec, hypre_KrylovPtrToMatvecT MatvecT, hypre_KrylovPtrToMatvecDestroy MatvecDestroy, hypre_KrylovPtrToInnerProd InnerProd, hypre_KrylovPtrToCopyVector CopyVector, hypre_KrylovPtrToClearVector ClearVector, hypre_KrylovPtrToScaleVector ScaleVector, hypre_KrylovPtrToAxpy Axpy, hypre_KrylovPtrToPrecondSetup PrecondSetup, hypre_KrylovPtrToPrecond Precond, hypre_KrylovPtrToPrecondT PrecondT )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRFunctionsCreate)( CommInfo, CreateVector, DestroyVector, MatvecCreate, Matvec, MatvecT, MatvecDestroy, InnerProd, CopyVector, ClearVector, ScaleVector, Axpy, PrecondSetup, Precond, PrecondT );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRGetFinalRelativeResidualNorm( void *cgnr_vdata, HYPRE_Real *relative_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRGetFinalRelativeResidualNorm)( cgnr_vdata, relative_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRGetNumIterations( void *cgnr_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRGetNumIterations)( cgnr_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRGetPrecond( void *cgnr_vdata, HYPRE_Solver *precond_data_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRGetPrecond)( cgnr_vdata, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRSetLogging( void *cgnr_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRSetLogging)( cgnr_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRSetMaxIter( void *cgnr_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRSetMaxIter)( cgnr_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRSetMinIter( void *cgnr_vdata, HYPRE_Int min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRSetMinIter)( cgnr_vdata, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRSetPrecond( void *cgnr_vdata, hypre_KrylovPtrToPrecond precond, hypre_KrylovPtrToPrecondT precondT, hypre_KrylovPtrToPrecondSetup precond_setup, void *precond_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRSetPrecond)( cgnr_vdata, precond, precondT, precond_setup, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRSetStopCrit( void *cgnr_vdata, HYPRE_Int stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRSetStopCrit)( cgnr_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRSetTol( void *cgnr_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRSetTol)( cgnr_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRSetup( void *cgnr_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRSetup)( cgnr_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CGNRSolve( void *cgnr_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CGNRSolve)( cgnr_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_COGMRESCreate( hypre_COGMRESFunctions *gmres_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESCreate)( gmres_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESDestroy( void *gmres_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESDestroy)( gmres_vdata );
}

/*--------------------------------------------------------------------------*/

hypre_COGMRESFunctions *
hypre_COGMRESFunctionsCreate( hypre_KrylovPtrToCAlloc CAlloc, hypre_KrylovPtrToFree Free, hypre_KrylovPtrToCommInfo CommInfo, hypre_KrylovPtrToCreateVector CreateVector, hypre_KrylovPtrToCreateVectorArray CreateVectorArray, hypre_KrylovPtrToDestroyVector DestroyVector, hypre_KrylovPtrToMatvecCreate MatvecCreate, hypre_KrylovPtrToMatvec Matvec, hypre_KrylovPtrToMatvecDestroy MatvecDestroy, hypre_KrylovPtrToInnerProd InnerProd, hypre_KrylovPtrToMassInnerProd MassInnerProd, hypre_KrylovPtrToMassDotpTwo MassDotpTwo, hypre_KrylovPtrToCopyVector CopyVector, hypre_KrylovPtrToClearVector ClearVector, hypre_KrylovPtrToScaleVector ScaleVector, hypre_KrylovPtrToAxpy Axpy, hypre_KrylovPtrToMassAxpy MassAxpy, hypre_KrylovPtrToPrecondSetup PrecondSetup, hypre_KrylovPtrToPrecond Precond )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESFunctionsCreate)( CAlloc, Free, CommInfo, CreateVector, CreateVectorArray, DestroyVector, MatvecCreate, Matvec, MatvecDestroy, InnerProd, MassInnerProd, MassDotpTwo, CopyVector, ClearVector, ScaleVector, Axpy, MassAxpy, PrecondSetup, Precond );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetAbsoluteTol( void *gmres_vdata, HYPRE_Real *a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetAbsoluteTol)( gmres_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetCGS( void *gmres_vdata, HYPRE_Int *cgs )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetCGS)( gmres_vdata, cgs );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetConverged( void *gmres_vdata, HYPRE_Int *converged )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetConverged)( gmres_vdata, converged );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetConvergenceFactorTol( void *gmres_vdata, HYPRE_Real *cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetConvergenceFactorTol)( gmres_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetFinalRelativeResidualNorm( void *gmres_vdata, HYPRE_Real *relative_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetFinalRelativeResidualNorm)( gmres_vdata, relative_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetKDim( void *gmres_vdata, HYPRE_Int *k_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetKDim)( gmres_vdata, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetLogging( void *gmres_vdata, HYPRE_Int *level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetLogging)( gmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetMaxIter( void *gmres_vdata, HYPRE_Int *max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetMaxIter)( gmres_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetMinIter( void *gmres_vdata, HYPRE_Int *min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetMinIter)( gmres_vdata, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetNumIterations( void *gmres_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetNumIterations)( gmres_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetPrecond( void *gmres_vdata, HYPRE_Solver *precond_data_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetPrecond)( gmres_vdata, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetPrintLevel( void *gmres_vdata, HYPRE_Int *level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetPrintLevel)( gmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetRelChange( void *gmres_vdata, HYPRE_Int *rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetRelChange)( gmres_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetResidual( void *gmres_vdata, void **residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetResidual)( gmres_vdata, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetSkipRealResidualCheck( void *gmres_vdata, HYPRE_Int *skip_real_r_check )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetSkipRealResidualCheck)( gmres_vdata, skip_real_r_check );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetTol( void *gmres_vdata, HYPRE_Real *tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetTol)( gmres_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESGetUnroll( void *gmres_vdata, HYPRE_Int *unroll )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESGetUnroll)( gmres_vdata, unroll );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetAbsoluteTol( void *gmres_vdata, HYPRE_Real a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetAbsoluteTol)( gmres_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetCGS( void *gmres_vdata, HYPRE_Int cgs )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetCGS)( gmres_vdata, cgs );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetConvergenceFactorTol( void *gmres_vdata, HYPRE_Real cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetConvergenceFactorTol)( gmres_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetKDim( void *gmres_vdata, HYPRE_Int k_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetKDim)( gmres_vdata, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetLogging( void *gmres_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetLogging)( gmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetMaxIter( void *gmres_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetMaxIter)( gmres_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetMinIter( void *gmres_vdata, HYPRE_Int min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetMinIter)( gmres_vdata, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetModifyPC( void *cogmres_vdata, hypre_KrylovPtrToModifyPC modify_pc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetModifyPC)( cogmres_vdata, modify_pc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetPrecond( void *gmres_vdata, hypre_KrylovPtrToPrecond precond, hypre_KrylovPtrToPrecondSetup precond_setup, void *precond_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetPrecond)( gmres_vdata, precond, precond_setup, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetPrintLevel( void *gmres_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetPrintLevel)( gmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetRelChange( void *gmres_vdata, HYPRE_Int rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetRelChange)( gmres_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetSkipRealResidualCheck( void *gmres_vdata, HYPRE_Int skip_real_r_check )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetSkipRealResidualCheck)( gmres_vdata, skip_real_r_check );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetTol( void *gmres_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetTol)( gmres_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetUnroll( void *gmres_vdata, HYPRE_Int unroll )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetUnroll)( gmres_vdata, unroll );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSetup( void *gmres_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSetup)( gmres_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_COGMRESSolve( void *gmres_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_COGMRESSolve)( gmres_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_FlexGMRESCreate( hypre_FlexGMRESFunctions *fgmres_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESCreate)( fgmres_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESDestroy( void *fgmres_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESDestroy)( fgmres_vdata );
}

/*--------------------------------------------------------------------------*/

hypre_FlexGMRESFunctions *
hypre_FlexGMRESFunctionsCreate( hypre_KrylovPtrToCAlloc CAlloc, hypre_KrylovPtrToFree Free, hypre_KrylovPtrToCommInfo CommInfo, hypre_KrylovPtrToCreateVector CreateVector, hypre_KrylovPtrToCreateVectorArray CreateVectorArray, hypre_KrylovPtrToDestroyVector DestroyVector, hypre_KrylovPtrToMatvecCreate MatvecCreate, hypre_KrylovPtrToMatvec Matvec, hypre_KrylovPtrToMatvecDestroy MatvecDestroy, hypre_KrylovPtrToInnerProd InnerProd, hypre_KrylovPtrToCopyVector CopyVector, hypre_KrylovPtrToClearVector ClearVector, hypre_KrylovPtrToScaleVector ScaleVector, hypre_KrylovPtrToAxpy Axpy, hypre_KrylovPtrToPrecondSetup PrecondSetup, hypre_KrylovPtrToPrecond Precond )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESFunctionsCreate)( CAlloc, Free, CommInfo, CreateVector, CreateVectorArray, DestroyVector, MatvecCreate, Matvec, MatvecDestroy, InnerProd, CopyVector, ClearVector, ScaleVector, Axpy, PrecondSetup, Precond );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetAbsoluteTol( void *fgmres_vdata, HYPRE_Real *a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetAbsoluteTol)( fgmres_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetConverged( void *fgmres_vdata, HYPRE_Int *converged )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetConverged)( fgmres_vdata, converged );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetConvergenceFactorTol( void *fgmres_vdata, HYPRE_Real *cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetConvergenceFactorTol)( fgmres_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetFinalRelativeResidualNorm( void *fgmres_vdata, HYPRE_Real *relative_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetFinalRelativeResidualNorm)( fgmres_vdata, relative_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetKDim( void *fgmres_vdata, HYPRE_Int *k_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetKDim)( fgmres_vdata, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetLogging( void *fgmres_vdata, HYPRE_Int *level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetLogging)( fgmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetMaxIter( void *fgmres_vdata, HYPRE_Int *max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetMaxIter)( fgmres_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetMinIter( void *fgmres_vdata, HYPRE_Int *min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetMinIter)( fgmres_vdata, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetNumIterations( void *fgmres_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetNumIterations)( fgmres_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetPrecond( void *fgmres_vdata, HYPRE_Solver *precond_data_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetPrecond)( fgmres_vdata, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetPrintLevel( void *fgmres_vdata, HYPRE_Int *level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetPrintLevel)( fgmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetResidual( void *fgmres_vdata, void **residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetResidual)( fgmres_vdata, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetStopCrit( void *fgmres_vdata, HYPRE_Int *stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetStopCrit)( fgmres_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESGetTol( void *fgmres_vdata, HYPRE_Real *tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESGetTol)( fgmres_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESModifyPCDefault( void *precond_data, HYPRE_Int iteration, HYPRE_Real rel_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESModifyPCDefault)( precond_data, iteration, rel_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetAbsoluteTol( void *fgmres_vdata, HYPRE_Real a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetAbsoluteTol)( fgmres_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetConvergenceFactorTol( void *fgmres_vdata, HYPRE_Real cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetConvergenceFactorTol)( fgmres_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetKDim( void *fgmres_vdata, HYPRE_Int k_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetKDim)( fgmres_vdata, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetLogging( void *fgmres_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetLogging)( fgmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetMaxIter( void *fgmres_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetMaxIter)( fgmres_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetMinIter( void *fgmres_vdata, HYPRE_Int min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetMinIter)( fgmres_vdata, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetModifyPC( void *fgmres_vdata, hypre_KrylovPtrToModifyPC modify_pc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetModifyPC)( fgmres_vdata, modify_pc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetPrecond( void *fgmres_vdata, hypre_KrylovPtrToPrecond precond, hypre_KrylovPtrToPrecondSetup precond_setup, void *precond_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetPrecond)( fgmres_vdata, precond, precond_setup, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetPrintLevel( void *fgmres_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetPrintLevel)( fgmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetStopCrit( void *fgmres_vdata, HYPRE_Int stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetStopCrit)( fgmres_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetTol( void *fgmres_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetTol)( fgmres_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSetup( void *fgmres_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSetup)( fgmres_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FlexGMRESSolve( void *fgmres_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FlexGMRESSolve)( fgmres_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_GMRESCreate( hypre_GMRESFunctions *gmres_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESCreate)( gmres_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESDestroy( void *gmres_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESDestroy)( gmres_vdata );
}

/*--------------------------------------------------------------------------*/

hypre_GMRESFunctions *
hypre_GMRESFunctionsCreate( hypre_KrylovPtrToCAlloc CAlloc, hypre_KrylovPtrToFree Free, hypre_KrylovPtrToCommInfo CommInfo, hypre_KrylovPtrToCreateVector CreateVector, hypre_KrylovPtrToCreateVectorArray CreateVectorArray, hypre_KrylovPtrToDestroyVector DestroyVector, hypre_KrylovPtrToMatvecCreate MatvecCreate, hypre_KrylovPtrToMatvec Matvec, hypre_KrylovPtrToMatvecDestroy MatvecDestroy, hypre_KrylovPtrToInnerProdTagged InnerProd, hypre_KrylovPtrToCopyVector CopyVector, hypre_KrylovPtrToClearVector ClearVector, hypre_KrylovPtrToScaleVector ScaleVector, hypre_KrylovPtrToAxpy Axpy, hypre_KrylovPtrToPrecond Precond, hypre_KrylovPtrToPrecondSetup PrecondSetup )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESFunctionsCreate)( CAlloc, Free, CommInfo, CreateVector, CreateVectorArray, DestroyVector, MatvecCreate, Matvec, MatvecDestroy, InnerProd, CopyVector, ClearVector, ScaleVector, Axpy, Precond, PrecondSetup );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetAbsoluteTol( void *gmres_vdata, HYPRE_Real *a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetAbsoluteTol)( gmres_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetConverged( void *gmres_vdata, HYPRE_Int *converged )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetConverged)( gmres_vdata, converged );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetConvergenceFactorTol( void *gmres_vdata, HYPRE_Real *cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetConvergenceFactorTol)( gmres_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetFinalRelativeResidualNorm( void *gmres_vdata, HYPRE_Real *relative_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetFinalRelativeResidualNorm)( gmres_vdata, relative_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetKDim( void *gmres_vdata, HYPRE_Int *k_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetKDim)( gmres_vdata, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetLogging( void *gmres_vdata, HYPRE_Int *level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetLogging)( gmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetMaxIter( void *gmres_vdata, HYPRE_Int *max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetMaxIter)( gmres_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetMinIter( void *gmres_vdata, HYPRE_Int *min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetMinIter)( gmres_vdata, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetNumIterations( void *gmres_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetNumIterations)( gmres_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetPrecond( void *gmres_vdata, HYPRE_Solver *precond_data_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetPrecond)( gmres_vdata, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetPrecondMatrix( void *gmres_vdata, HYPRE_Matrix *precond_matrix_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetPrecondMatrix)( gmres_vdata, precond_matrix_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetPrintLevel( void *gmres_vdata, HYPRE_Int *level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetPrintLevel)( gmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetRefSolution( void *gmres_vdata, void **xref )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetRefSolution)( gmres_vdata, xref );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetRelChange( void *gmres_vdata, HYPRE_Int *rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetRelChange)( gmres_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetResidual( void *gmres_vdata, void **residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetResidual)( gmres_vdata, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetSkipRealResidualCheck( void *gmres_vdata, HYPRE_Int *skip_real_r_check )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetSkipRealResidualCheck)( gmres_vdata, skip_real_r_check );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetStopCrit( void *gmres_vdata, HYPRE_Int *stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetStopCrit)( gmres_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESGetTol( void *gmres_vdata, HYPRE_Real *tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESGetTol)( gmres_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetAbsoluteTol( void *gmres_vdata, HYPRE_Real a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetAbsoluteTol)( gmres_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetConvergenceFactorTol( void *gmres_vdata, HYPRE_Real cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetConvergenceFactorTol)( gmres_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetHybrid( void *gmres_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetHybrid)( gmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetKDim( void *gmres_vdata, HYPRE_Int k_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetKDim)( gmres_vdata, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetLogging( void *gmres_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetLogging)( gmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetMaxIter( void *gmres_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetMaxIter)( gmres_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetMinIter( void *gmres_vdata, HYPRE_Int min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetMinIter)( gmres_vdata, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetPrecond( void *gmres_vdata, hypre_KrylovPtrToPrecond precond, hypre_KrylovPtrToPrecondSetup precond_setup, void *precond_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetPrecond)( gmres_vdata, precond, precond_setup, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetPrecondMatrix( void *gmres_vdata, void *precond_matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetPrecondMatrix)( gmres_vdata, precond_matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetPrintLevel( void *gmres_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetPrintLevel)( gmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetRefSolution( void *gmres_vdata, void *xref )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetRefSolution)( gmres_vdata, xref );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetRelChange( void *gmres_vdata, HYPRE_Int rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetRelChange)( gmres_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetSkipRealResidualCheck( void *gmres_vdata, HYPRE_Int skip_real_r_check )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetSkipRealResidualCheck)( gmres_vdata, skip_real_r_check );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetStopCrit( void *gmres_vdata, HYPRE_Int stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetStopCrit)( gmres_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetTol( void *gmres_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetTol)( gmres_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSetup( void *gmres_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSetup)( gmres_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GMRESSolve( void *gmres_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GMRESSolve)( gmres_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_LGMRESCreate( hypre_LGMRESFunctions *lgmres_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESCreate)( lgmres_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESDestroy( void *lgmres_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESDestroy)( lgmres_vdata );
}

/*--------------------------------------------------------------------------*/

hypre_LGMRESFunctions *
hypre_LGMRESFunctionsCreate( hypre_KrylovPtrToCAlloc CAlloc, hypre_KrylovPtrToFree Free, hypre_KrylovPtrToCommInfo CommInfo, hypre_KrylovPtrToCreateVector CreateVector, hypre_KrylovPtrToCreateVectorArray CreateVectorArray, hypre_KrylovPtrToDestroyVector DestroyVector, hypre_KrylovPtrToMatvecCreate MatvecCreate, hypre_KrylovPtrToMatvec Matvec, hypre_KrylovPtrToMatvecDestroy MatvecDestroy, hypre_KrylovPtrToInnerProd InnerProd, hypre_KrylovPtrToCopyVector CopyVector, hypre_KrylovPtrToClearVector ClearVector, hypre_KrylovPtrToScaleVector ScaleVector, hypre_KrylovPtrToAxpy Axpy, hypre_KrylovPtrToPrecondSetup PrecondSetup, hypre_KrylovPtrToPrecond Precond )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESFunctionsCreate)( CAlloc, Free, CommInfo, CreateVector, CreateVectorArray, DestroyVector, MatvecCreate, Matvec, MatvecDestroy, InnerProd, CopyVector, ClearVector, ScaleVector, Axpy, PrecondSetup, Precond );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetAbsoluteTol( void *lgmres_vdata, HYPRE_Real *a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetAbsoluteTol)( lgmres_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetAugDim( void *lgmres_vdata, HYPRE_Int *aug_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetAugDim)( lgmres_vdata, aug_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetConverged( void *lgmres_vdata, HYPRE_Int *converged )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetConverged)( lgmres_vdata, converged );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetConvergenceFactorTol( void *lgmres_vdata, HYPRE_Real *cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetConvergenceFactorTol)( lgmres_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetFinalRelativeResidualNorm( void *lgmres_vdata, HYPRE_Real *relative_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetFinalRelativeResidualNorm)( lgmres_vdata, relative_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetKDim( void *lgmres_vdata, HYPRE_Int *k_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetKDim)( lgmres_vdata, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetLogging( void *lgmres_vdata, HYPRE_Int *level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetLogging)( lgmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetMaxIter( void *lgmres_vdata, HYPRE_Int *max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetMaxIter)( lgmres_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetMinIter( void *lgmres_vdata, HYPRE_Int *min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetMinIter)( lgmres_vdata, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetNumIterations( void *lgmres_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetNumIterations)( lgmres_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetPrecond( void *lgmres_vdata, HYPRE_Solver *precond_data_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetPrecond)( lgmres_vdata, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetPrintLevel( void *lgmres_vdata, HYPRE_Int *level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetPrintLevel)( lgmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetResidual( void *lgmres_vdata, void **residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetResidual)( lgmres_vdata, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetStopCrit( void *lgmres_vdata, HYPRE_Int *stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetStopCrit)( lgmres_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESGetTol( void *lgmres_vdata, HYPRE_Real *tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESGetTol)( lgmres_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetAbsoluteTol( void *lgmres_vdata, HYPRE_Real a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetAbsoluteTol)( lgmres_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetAugDim( void *lgmres_vdata, HYPRE_Int aug_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetAugDim)( lgmres_vdata, aug_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetConvergenceFactorTol( void *lgmres_vdata, HYPRE_Real cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetConvergenceFactorTol)( lgmres_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetKDim( void *lgmres_vdata, HYPRE_Int k_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetKDim)( lgmres_vdata, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetLogging( void *lgmres_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetLogging)( lgmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetMaxIter( void *lgmres_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetMaxIter)( lgmres_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetMinIter( void *lgmres_vdata, HYPRE_Int min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetMinIter)( lgmres_vdata, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetPrecond( void *lgmres_vdata, hypre_KrylovPtrToPrecond precond, hypre_KrylovPtrToPrecondSetup precond_setup, void *precond_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetPrecond)( lgmres_vdata, precond, precond_setup, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetPrintLevel( void *lgmres_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetPrintLevel)( lgmres_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetStopCrit( void *lgmres_vdata, HYPRE_Int stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetStopCrit)( lgmres_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetTol( void *lgmres_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetTol)( lgmres_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSetup( void *lgmres_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSetup)( lgmres_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LGMRESSolve( void *lgmres_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LGMRESSolve)( lgmres_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_PCGCreate( hypre_PCGFunctions *pcg_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGCreate)( pcg_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGDestroy( void *pcg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGDestroy)( pcg_vdata );
}

/*--------------------------------------------------------------------------*/

hypre_PCGFunctions *
hypre_PCGFunctionsCreate( hypre_KrylovPtrToCAlloc CAlloc, hypre_KrylovPtrToFree Free, hypre_KrylovPtrToCommInfo CommInfo, hypre_KrylovPtrToCreateVector CreateVector, hypre_KrylovPtrToDestroyVector DestroyVector, hypre_KrylovPtrToMatvecCreate MatvecCreate, hypre_KrylovPtrToMatvec Matvec, hypre_KrylovPtrToMatvecDestroy MatvecDestroy, hypre_KrylovPtrToInnerProd InnerProd, hypre_KrylovPtrToCopyVector CopyVector, hypre_KrylovPtrToClearVector ClearVector, hypre_KrylovPtrToScaleVector ScaleVector, hypre_KrylovPtrToAxpy Axpy, hypre_KrylovPtrToPrecondSetup PrecondSetup, hypre_KrylovPtrToPrecond Precond )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGFunctionsCreate)( CAlloc, Free, CommInfo, CreateVector, DestroyVector, MatvecCreate, Matvec, MatvecDestroy, InnerProd, CopyVector, ClearVector, ScaleVector, Axpy, PrecondSetup, Precond );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetAbsoluteTol( void *pcg_vdata, HYPRE_Real *a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetAbsoluteTol)( pcg_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetAbsoluteTolFactor( void *pcg_vdata, HYPRE_Real *atolf )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetAbsoluteTolFactor)( pcg_vdata, atolf );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetConverged( void *pcg_vdata, HYPRE_Int *converged )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetConverged)( pcg_vdata, converged );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetConvergenceFactorTol( void *pcg_vdata, HYPRE_Real *cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetConvergenceFactorTol)( pcg_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetFinalRelativeResidualNorm( void *pcg_vdata, HYPRE_Real *relative_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetFinalRelativeResidualNorm)( pcg_vdata, relative_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetFlex( void *pcg_vdata, HYPRE_Int *flex )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetFlex)( pcg_vdata, flex );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetLogging( void *pcg_vdata, HYPRE_Int *level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetLogging)( pcg_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetMaxIter( void *pcg_vdata, HYPRE_Int *max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetMaxIter)( pcg_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetNumIterations( void *pcg_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetNumIterations)( pcg_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetPrecond( void *pcg_vdata, HYPRE_Solver *precond_data_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetPrecond)( pcg_vdata, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetPrecondMatrix( void *pcg_vdata, HYPRE_Matrix *precond_matrix_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetPrecondMatrix)( pcg_vdata, precond_matrix_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetPrintLevel( void *pcg_vdata, HYPRE_Int *level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetPrintLevel)( pcg_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetRecomputeResidual( void *pcg_vdata, HYPRE_Int *recompute_residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetRecomputeResidual)( pcg_vdata, recompute_residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetRecomputeResidualP( void *pcg_vdata, HYPRE_Int *recompute_residual_p )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetRecomputeResidualP)( pcg_vdata, recompute_residual_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetRelChange( void *pcg_vdata, HYPRE_Int *rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetRelChange)( pcg_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetResidual( void *pcg_vdata, void **residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetResidual)( pcg_vdata, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetResidualTol( void *pcg_vdata, HYPRE_Real *rtol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetResidualTol)( pcg_vdata, rtol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetSkipBreak( void *pcg_vdata, HYPRE_Int *skip_break )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetSkipBreak)( pcg_vdata, skip_break );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetStopCrit( void *pcg_vdata, HYPRE_Int *stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetStopCrit)( pcg_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetTol( void *pcg_vdata, HYPRE_Real *tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetTol)( pcg_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGGetTwoNorm( void *pcg_vdata, HYPRE_Int *two_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGGetTwoNorm)( pcg_vdata, two_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGPrintLogging( void *pcg_vdata, HYPRE_Int myid )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGPrintLogging)( pcg_vdata, myid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetAbsoluteTol( void *pcg_vdata, HYPRE_Real a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetAbsoluteTol)( pcg_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetAbsoluteTolFactor( void *pcg_vdata, HYPRE_Real atolf )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetAbsoluteTolFactor)( pcg_vdata, atolf );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetConvergenceFactorTol( void *pcg_vdata, HYPRE_Real cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetConvergenceFactorTol)( pcg_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetFlex( void *pcg_vdata, HYPRE_Int flex )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetFlex)( pcg_vdata, flex );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetHybrid( void *pcg_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetHybrid)( pcg_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetLogging( void *pcg_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetLogging)( pcg_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetMaxIter( void *pcg_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetMaxIter)( pcg_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetPrecond( void *pcg_vdata, hypre_KrylovPtrToPrecond precond, hypre_KrylovPtrToPrecondSetup precond_setup, void *precond_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetPrecond)( pcg_vdata, precond, precond_setup, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetPrecondMatrix( void *pcg_vdata, void *precond_matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetPrecondMatrix)( pcg_vdata, precond_matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetPreconditioner( void *pcg_vdata, void *precond_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetPreconditioner)( pcg_vdata, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetPrintLevel( void *pcg_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetPrintLevel)( pcg_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetRecomputeResidual( void *pcg_vdata, HYPRE_Int recompute_residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetRecomputeResidual)( pcg_vdata, recompute_residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetRecomputeResidualP( void *pcg_vdata, HYPRE_Int recompute_residual_p )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetRecomputeResidualP)( pcg_vdata, recompute_residual_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetRelChange( void *pcg_vdata, HYPRE_Int rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetRelChange)( pcg_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetResidualTol( void *pcg_vdata, HYPRE_Real rtol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetResidualTol)( pcg_vdata, rtol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetSkipBreak( void *pcg_vdata, HYPRE_Int skip_break )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetSkipBreak)( pcg_vdata, skip_break );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetStopCrit( void *pcg_vdata, HYPRE_Int stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetStopCrit)( pcg_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetTol( void *pcg_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetTol)( pcg_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetTwoNorm( void *pcg_vdata, HYPRE_Int two_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetTwoNorm)( pcg_vdata, two_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSetup( void *pcg_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSetup)( pcg_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PCGSolve( void *pcg_vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PCGSolve)( pcg_vdata, A, b, x );
}


#endif

